;********
;isr_wyz: Interrupt service routine for the WYZplayer
;********
isr_wyz:		push	af			;Save registers
			push	bc
			push	de
			push	hl
			push	ix
			push	iy
			ld	a,(lastbank)		;Get current page
			ld	(isr_wyz_rest+1),a	;Keep it
			ld	a,6
			call	setbank			;Set page 6
			ld	a,(current_sound)
                	and	1			;Check if music is disabled
                	jr	z,isr_wyz_dosound
                	call	SILENCIAPLAYER		;Disable music
                	jr	isr_wyz_rest
isr_wyz_dosound:	call    PLAY
			ld	HL,PSG_REG
			ld	DE,PSG_REG_SEC
			ld	BC,14
			ldir
                	call    REPRODUCE_SONIDO
                	call    ROUT
isr_wyz_rest:           ld	a,0			
			call	setbank			;Restore previous page
           		pop	iy			;Restore registers
                	pop	ix
                	pop	hl
                	pop	de
                	pop	bc
                	pop	af
                	jp	int_end			;Exit interrupt

;***********
;rec_getbit: get one bit from recording stream
;***********
rec_getbit:		ld	a,(current_rec_byte)	;current byte
			add	a,a			;get a bit
			jr	nz,rec_bitgotten
							;If we've read the last bit, it was the marker, so read the next byte
							;from page 1
			push	hl			
			di				;Disable ints
			ld	a,1
			call	setbank			;Set bank 1
			ld	hl,(current_rec_addr)	;Get next byte address
			ld	a,(hl)			;Get byte
			inc	hl
			ld	(current_rec_addr),hl	;Update address
			pop	hl
			push	af			;Keep byte
			call	setbank0		;Restore bank 0
			pop	af			;Restore byte
			ei				;Enable ints
			scf				;Marker bit
			rla				;Get first bit
rec_bitgotten:		ld	(current_rec_byte),a	;Update current byte
			ret

;*************
;rec_get4bits: Get 4 bits in lower register C from record stream
;*************
rec_get4bits:		ld	b,4			;4 bits
rec_getting4:		call	rec_getbit		;Get 1 bit in carry flag
			ld	a,c
			rra				;Enter bit into register from the right
			ld	c,a
			djnz	rec_getting4		;Repeat 4 times
			rrca
			rrca
			rrca
			rrca				;Move bits to low positions
			and	15			;Clear high bits
			ld	c,a			;Result in C
			ret

;************
;setrec4bits: Insert the 4 lower bits of register C into the recording stream
;************
setrec4bits:		ld	a,(recording)		
			and	a
			ret	z			;Return if in 48k mode
			push	bc
			ld	b,4			;Number of bits to enter
setrecloop:		rr	c			;Get bit
			ld	a,(current_rec_byte)	;Get current byte
			adc	a,a			;Add bit to current byte
			jr	nc,setrecloopout
			push	af			;If carry, we need to store this byte.
			ld	a,1
			di				;Disable interrupts
			call	setbank			;Set bank 1
			pop	af
			push	hl		
			ld	hl,(current_rec_addr)	;Get current recording address
			ld	(hl),a			;Store byte
			inc	hl			;Increase address
			ld	(current_rec_addr),hl	;Store it
			pop	hl
			call	setbank0		;Set bank 0
			ei				;Enable interrupts
			ld	a,1			;Marker bit
setrecloopout:		ld	(current_rec_byte),a	;Update current byte
			djnz	setrecloop		;Repeat for all bits
			pop	bc
			ret

;********
;setrec1: Insert a 1 bit into the recording stream
;********
setrec1:		ld	a,55			;SCF opcode
			jr	setrec

;********
;setrec0: Insert a 0 bit into the recording stream
;********
setrec0:		ld	a,167			;AND A opcode
setrec:			ld	(setrecpatch),a		;Patch code
			ld	a,(recording)
			and	a
			ret	z			;Return if in 48k mode
setrecpatch:		and	a			;Excite C flag depending on bit
setrecc:		ld	a,(current_rec_byte)	;Get current byte
			adc	a,a			;Add bit
			jr	nc,setrecend
			push	af			;If carry, we need to store this byte.
			ld	a,1
			di				;Disable interrupts
			call	setbank			;Set bank 1
			pop	af
			push	hl
			ld	hl,(current_rec_addr)	;Get current recording address
			ld	(hl),a			;Store byte
			inc	hl			;Increase address
			ld	(current_rec_addr),hl	;Store it
			pop	hl
			call	setbank0		;Set bank 0
			ei				;Enable interrupts
			ld	a,1			;Marker bit
setrecend:		ld	(current_rec_byte),a	;Update current byte
			ret

;*************
;record_flush: End recording by flushing the needed bits to complete one last byte, and store final cars state
;*************
record_flush:		ld	a,(recording)		;Flush the last bits
			cp	1
			ret	nz			;Return if we're replaying
			ld	a,(current_rec_byte)	;Get current byte
record_flushing:	add	a,a			;Flush
			jr	nc,record_flushing	;Keep moving bits to the left until the marker bit gets out
			ld	hl,(current_rec_addr)	;Get recording address
			ld	b,a			;Keep byte in B
			ld	a,1
			di				;Disable ints
			call	setbank			;Set bank 1
			ld	(hl),b			;Store last byte
			ld	(max_rec_addr),hl	;Store ending position of recording
			ld	hl,car1			;Copy from here
			ld	de,49152		;To here
			ld	bc,end_cars-car1	;All cars data
			ldir				;Copy final stage state
			call	setbank0		;Set bank 0
			ei				;Enable ints
			ret

;*********************
;record_preparerecord: Prepare to record
;*********************
record_preparerecord:	ld	hl,49152+end_cars-car1
			ld	(current_rec_addr),hl	;Set start address
			ld	a,1
			ld	(current_rec_byte),a	;Set first marker bit
			ret

;*******************
;record_prepareplay: Prepare the replay
;*******************
record_prepareplay:	ld	hl,49152+end_cars-car1	
			ld	(current_rec_addr),hl	;Set start address
			ld	a,128
			ld	(current_rec_byte),a	;Set first marker bit
			ld	a,2
			ld	(recording),a		;Recording mode to 2 (replay)
			ld	ix,car1			;First car
			ld	b,4			;Number of cars
record_writecontrol:	ld	de,control_play
			ld	(ix+SP_CONTROL+1),d
			ld	(ix+SP_CONTROL),e	;For every car, set their control to control_play
			ld	de,car2-car1
			add	ix,de			;Point to next car
			djnz	record_writecontrol
			ret

;*********
;load_wyz: Load a song for WYZPlayer
;*********
load_wyz:		ld	a,6
			call	setbank			;Set bank 6
			ld	a,h
			call	CARGA_CANCION		;Load song
			ld	hl,isr_wyz
			ld	(interrupt_redir+1),hl	;Set interrupt to isr_wyz routine
			jp	setbank0		;Set bank 0 and exit

;********
;rainbow: Do the Rainbow effect on menu logo
;********
rainbow:		push	af			;Save registers
			ex	af,af'
			push	af
			push	bc
			push	de
			push	hl
			push	ix
			push	iy
rainbow_disable:	ld	a,1
			and	a
			jp	z,end_rainbow		;If rainbow is disabled, jump it
			ld	bc,523			;Wait some time...
rainbowloop:		dec	bc			;6
			ld	a,b			;4
			or	c			;4
			jr	nz,rainbowloop		;12,7
			and	a			;4
			ret	c			;5
			nop				;4
;			nop
;			nop
			ld	(keepstack),sp		;Store current stack
			ld	ix,$581e		;First position to write, final part
			ld	hl,$580c		;First position to write, first part
			ld	iy,$5816		;First position to write, middle part
			ld	c,2			;
			ld	a,1
rainbow_loop_outer:	ld	b,4			; 	4 double lines
rainbow_loop_inner_2:	ld	a,b			;	
			dec	a			;  4
			ld	(rainbow_patch+2),a	; 10	Select color offset
rainbow_patch:		ld	d,(ix+0)		; 19	Get color
			ld	e,d 			;  4	In both registers
			ld	sp,hl			;Load first address in stack
			push	de
			push	de
			push	de
			push	de
			push	de			;Fill 10 bytes
			ld	sp,iy			;Load second address in stack
			push	de
			push	de
			push	de
			push	de
			push	de			;Fill 10 bytes
			ld	sp,ix			;Load third address in stack
			push	de
			push	de
			push	de
			push	de			;Fill 8 bytes
					;Pause here
			xor	64
			and	a
			ret	c
			ret	c
			ret	c
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			djnz	rainbow_loop_inner_1
			dec	c			; 4
			jr	z,rainbow_nomore	; 7
			nop
			nop
			nop
			ld	de,32			;10
			add	hl,de			;11 
			add	ix,de			;15
			add	iy,de			;15	Pointers to next line
			jp	rainbow_loop_outer	;10
rainbow_nomore:		ld	hl,(rainbow_rompoint)	;Get ROM pointer
			ld	a,(hl)			;Get ROM byte
			and	71			;Keep only bright and ink
			ld	($581e+3),a		;Keep color for next use
			xor	64			;Reverse bright
			ld	($583e+0),a		;Keep color for next use
			inc	hl			;Increase pointer
			ld	a,h
			and	63
			ld	h,a			;Make sure the pointer stays in ROM
			ld	(rainbow_rompoint),hl	;Update ROM pointer
			ld	a,(hl)			;Repeat for 3 more bytes
			and	71
			ld	($581e+2),a
			xor	64
			ld	($583e+1),a
			inc	hl
			ld	a,(hl)
			and	71
			ld	($581e+1),a
			xor	64
			ld	($583e+2),a
			inc	hl
			ld	a,(hl)
			and	71
			ld	($581e+0),a
			xor	64
			ld	($583e+3),a
			ld	sp,(keepstack)		;Restore stack pointer
end_rainbow:		ld	a,6
			call	setbank			;Set bank 6
			call	vortex_isr		;Call Vortex
			call	setbank0		;Set bank 0
			pop	iy			;Restore registers
			pop	ix
			pop	hl
			pop	de
			pop	bc
			pop	af
			ex	af,af'
			pop	af
			jp	int_end			;End interrupt
rainbow_loop_inner_1:			;More pause here: 87 states
			and	a	;4
			ret	c
			nop
			nop
			inc	a
			and	64+7
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			jp	rainbow_loop_inner_2
rainbow_rompoint:	defw	0